<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if ($_SESSION['VALID_USER_NAME'] == false) {
    header("location: login");
}
//variables
$_SESSION['voucher_type'] = clean_data($_GET['voucher_type']);
$voucher_type = $_SESSION['voucher_type'];


$menu_id = clean_data($_GET['menu_id']);
$p_comp_id = clean_data($_GET['comp_id']);

$p_year_id = clean_data($_GET['year_id']);
if (empty($p_year_id)) {
    $year_id = clean_data($_SESSION["year_id"]);
} else {

    $year_id =  $p_year_id;
}

if (empty($p_comp_id)) {
    $comp_id = clean_data($_SESSION["comp_id"]);
} else {

    $comp_id =  $p_comp_id;
}

$add = clean_data($_GET['add']);
$_SESSION['add'] = $add;
$emp_id = $_SESSION['VALID_USER_NAME'];
$loc_id =  $_SESSION["short_name"];

if ($add == "Y") {
    $lineitem = 0;
    $acct_id = '';
    $voucher_date = date('d-m-Y');
    $_SESSION['voucher_type'] = clean_data($_GET['voucher_type']);
    $voucher_type = $_SESSION['voucher_type'];
    $comp_id = clean_data($_SESSION["comp_id"]);


    $close_date = find_value('v_system', 'date_close', '');
    $v_date = date('d-m-Y', strtotime($close_date . ' +1 day'));



    //MAXIMUM VOUCHER ID CHK QUERY
    try {
        $Maxquery =  "SELECT max(v.v_id) + 1 v_id FROM voucher_id v
		WHERE v_type = ? and comp_id = ? ";
        $max_query = $dbcon->prepare($Maxquery);
        $max_query->execute(array($voucher_type, $comp_id));
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }

    $row_max = $max_query->fetch(PDO::FETCH_OBJ);
    $v_id = $row_max->v_id;
    if (empty($v_id)) {
        $v_id = 1;
    }


    //MAXIMUM VOUCHER ID INSERT NEW ID QUERY
    try {
        $InserMaxquery =  "INSERT INTO voucher_id (v_id, v_type,comp_id) VALUES (?, ?, ? )";
        $insert_max = $dbcon->prepare($InserMaxquery);
        $insert_max->execute(array($v_id, $voucher_type, $comp_id));
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }

    $v_id =  $v_id;



    // END MAXIMUM VOUCHER ID CHK QUERY



    $customer_name = '';
    $customer_phone = '';
    $customer_cash = '';





    //MAXIMUM INVOICE ID CHK QUERY
    try {
        $Maxquery_invoice =  "SELECT LPAD(IFNULL(max(substr(v.bill_no,-4)),0)+1,4,'0') v_id FROM sl_invoice v
		WHERE v.comp_id = ? ";
        $max_query_inv = $dbcon->prepare($Maxquery_invoice);
        $max_query_inv->execute(array($comp_id));
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }

    $row_max_invoice = $max_query_inv->fetch(PDO::FETCH_OBJ);
    $invoiceNo = $row_max_invoice->v_id;
    $invoice_no = $loc_id . $invoiceNo;







    $discount_voucher_id = "";
    $return_cash = "";
    $bill_type = '';
    $sp = "";
    $invoice_no = "";
    $discp_m = "";
    $disc_amt_m = "";
    $net_amt = "";
    $net_payable = "";
    $adv_amt = "";
    $dc_amt = "";
    $location_id = "";
} else //EDIT
{
    $voucher_type = clean_data($_SESSION['voucher_type']);
    $v_id = clean_data($_GET['v_id']);


    try {
        $edit_query =  "SELECT * FROM sl_invoice m  WHERE m.voucher_id = ? AND m.comp_id = ? AND m.year_id = ?";
        $edit_result = $dbcon->prepare($edit_query);
        $edit_result->execute(array($v_id, $comp_id, $year_id));
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }

    $rowm = $edit_result->fetch(PDO::FETCH_OBJ);


    $voucherdate = $rowm->voucher_date;
    $v_date = date('d-m-Y', strtotime($voucherdate));
    $acct_id = $rowm->acct_id;
    $customer_name = $rowm->customer_name;
    $customer_phone = $rowm->customer_phone;
    $customer_cash = $rowm->customer_cash;
    $return_cash = $rowm->return_cash;
    $bill_type = $rowm->bill_type;
    $invoice_no = $rowm->bill_no;
    $sp_id = $rowm->sp_id;
    $discount_voucher_id = $rowm->discount_voucher_no;
    $discp_m = $rowm->discp;
    $disc_amt_m = $rowm->disc_amt;
    $net_amt = $rowm->net_amt;
    $net_payable = $rowm->net_payable;
    $adv_amt = $rowm->adv_amt;
    $dc_amt = $rowm->dc_amt;
    $location_id = $rowm->loc_id;
    $base_doc = $rowm->base_doc;
    $base_voucher_id = $rowm->base_voucher_id;

    $new_base_voucher_id = substr($base_voucher_id, 4, 6);

    $purchase_note = $rowm->particulars;
}




?>
<?php include('header.php'); ?>

<title>Add Invoice | <?php echo $row->acct_name; ?></title>

<?php include('left.php'); ?>



<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <ul class="breadcrumb breadcrumb-style ">
            <li class="breadcrumb-item">
                <h4 class="page-title m-b-0">Sale</h4>
            </li>
            <li class="breadcrumb-item">
                <a href="sale_invoice?menu_id=<?php echo $menu_id; ?>">
                    Sale Invoice</a>
            </li>
            <li class="breadcrumb-item active">Add Invoice</li>
        </ul>

        <div class="section-body">


            <form class="form-horizontal" name="sale_invoice" id="sale_invoice">


                <input type="hidden" class="form-control" name="p_comp_id" id="p_comp_id" value="<?php echo $comp_id; ?>">

                <!------------------------START MASTER TABLE---------------------------->
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive">

                                    <table class="table table-borderless">
                                        <thead>
                                            <tr>

                                                <!-- VOUCHER ID -->
                                                <td>
                                                    <label class="control-label pull-right" style="font-weight: bold; color: black;">Voucher ID:</label>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control" name="voucher_id" id="voucher_id" placeholder="voucher id" value="<?php echo $v_id; ?>" readonly  style="width: 150px;">
                                                </td>


                                                <!-- DATE -->
                                                <td>
                                                    <label class="control-label pull-right" style="font-weight: bold; color: black;">Date:</label>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control " name="v_date" id="v_date" placeholder="Date" readonly value="<?php echo $v_date; ?>"  style="width: 150px;">
                                                </td>







                                                <!-- SALE TYPE-->
                                                <td>
                                                    <label class="control-label pull-right" style="font-weight: bold; color: black;">Sale Type</label>
                                                </td>
                                                <?php
                                                try {
                                                    $p_query =  "SELECT p.acct_id, concat(p.acct_name,'-',p.acct_id) acct_name FROM v_party p  ORDER BY p.acct_id ASC ";

                                                    $p_result = $dbcon->prepare($p_query);
                                                    $p_result->execute(array());
                                                } catch (PDOException $e) {
                                                    echo "Error : " . $e->getMessage();
                                                }

                                                ?>

                                                <td>
                                                    <select style="width:300px;" name="acct_id" id="acct_id" class="acct_id remove_acct_id">
                                                        <option value="">Select Party</option>
                                                        <?php
                                                        $debtors = find_value('company', 'debtors', " AND comp_id = '$comp_id'");

                                                        ?>


                                                        <?php
                                                        while ($p_row = $p_result->fetch(PDO::FETCH_OBJ)) {
                                                            if ($add == 'Y') {

                                                                if ($debtors == $p_row->acct_id) {
                                                                    echo '<option  value="' . $p_row->acct_id . '"selected>' . $p_row->acct_name . '</option>';
                                                                } else {

                                                                    echo '<option  value="' . $p_row->acct_id . '">' . $p_row->acct_name . '</option>';
                                                                }
                                                            } else {
                                                                if ($acct_id == $p_row->acct_id) {
                                                                    echo '<option  value="' . $p_row->acct_id . '"selected>' . $p_row->acct_name . '</option>';
                                                                }

                                                                echo '<option  value="' . $p_row->acct_id . '">' . $p_row->acct_name . '</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>


                                                  <!--  <input type="text" class="form-control" id="party_bal" readonly placeholder="Party Balance">

                                                    <input type="text" class="form-control" id="credit_limit" readonly placeholder="Credit Limit">
-->

                                                </td>
                                            </tr>
                                            <tr>

                                                <!-- INVOICE NO-->
                                                <td>
                                                    <label class="control-label pull-right" style="font-weight: bold; color: black;"> Inv No:</label>
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control" name="inv_no" id="inv_no" autocomplete="on" value="<?php echo $invoice_no; ?>"  style="width: 150px;">
                                                </td>



                                                <td>
                                                    <label class="control-label pull-right" style="font-weight: bold; color: black;">Salesman</label>
                                                </td>
                                                <?php
                                                try {
                                                    $p_query =  "SELECT s.acct_id, s.acct_name FROM sp s  ORDER BY s.acct_id ASC ";

                                                    $p_result = $dbcon->prepare($p_query);
                                                    $p_result->execute(array());
                                                } catch (PDOException $e) {
                                                    echo "Error : " . $e->getMessage();
                                                }

                                                ?>

                                                <td>
                                                    <select style="width:150px;" name="sp_id" id="sp_id" class="acct_id">


                                                        <option value=""></option>


                                                        <?php
                                                        while ($p_row = $p_result->fetch(PDO::FETCH_OBJ)) {

                                                            if ($sp_id == $p_row->acct_id) {
                                                                echo '<option  value="' . $p_row->acct_id . '"selected>' . $p_row->acct_name . '</option>';
                                                            } else {
                                                                echo '<option  value="' . $p_row->acct_id . '">' . $p_row->acct_name . '</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </td>





                                                <td>
                                                    <label class="control-label pull-right" style="font-weight: bold; color: black;">Godown:</label>
                                                </td>
                                                <?php
                                                try {
                                                    $p_query =  "SELECT l.loc_id, l.loc_name FROM location l ORDER BY l.loc_id ASC ";

                                                    $p_result = $dbcon->prepare($p_query);
                                                    $p_result->execute(array());
                                                } catch (PDOException $e) {
                                                    echo "Error : " . $e->getMessage();
                                                }

                                                ?>

                                                <td>
                                                    <select name="loc_id" id="loc_id" class="acct_id" style="width: 300px;">


                                                        <?php
                                                        $loc_id = find_value('location', 'loc_id', " AND comp_id = '$comp_id'");
                                                        ?>

                                                        <?php
                                                        while ($p_row = $p_result->fetch(PDO::FETCH_OBJ)) {
                                                            if ($add == 'Y') {
                                                                if ($loc_id == $p_row->loc_id) {
                                                                    echo '<option  value="' . $p_row->loc_id . '" selected>' . $p_row->loc_name . '</option>';
                                                                } else {

                                                                    echo '<option  value="' . $p_row->loc_id . '">' . $p_row->loc_name . '</option>';
                                                                }
                                                            } else {
                                                                if ($location_id == $p_row->loc_id) {
                                                                    echo '<option  value="' . $p_row->loc_id . '"selected>' . $p_row->loc_name . '</option>';
                                                                }
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </td>






                                            </tr>




                                            <tr>



                                                <td> <label class="control-label pull-right" style="font-weight: bold; color: black;">Base Document</label></td>
                                                <td>
                                                    <select style="width:150px;" name="base_doc" id="base_doc" class="acct_id">
                                                        <option value=""></option>
                                                        <?php

                                                        if ($add != 'Y') {

                                                            if ($base_doc == 'QT') {
                                                                echo '<option  value="' . "QT" . '"selected>' . "Qoute" . '</option>';
                                                            } else {
                                                                echo '<option  value="' . "QT" . '">' . "Qoute" . '</option>';
                                                            }

                                                            if ($base_doc == 'SO') {
                                                                echo '<option  value="' . "SO" . '"selected>' . "Order" . '</option>';
                                                            } else {
                                                                echo '<option  value="' . "SO" . '">' . "Order" . '</option>';
                                                            }

                                                            if ($base_doc == 'DC') {
                                                                echo '<option  value="' . "DC" . '"selected>' . "Delivery Challan" . '</option>';
                                                            } else {
                                                                echo '<option  value="' . "DC" . '">' . "Delivery Challan" . '</option>';
                                                            }


                                                            if ($base_doc == 'OG') {
                                                                echo '<option  value="' . "OG" . '"selected>' . "Gatepass" . '</option>';
                                                            } else {
                                                                echo '<option  value="' . "OG" . '">' . "Gatepass" . '</option>';
                                                            }
                                                        } else {
                                                            ?>

                                                            <option value="QT">Quote</option>
                                                            <option value="SO">Order</option>
                                                            <option value="DC">Delivery Challan</option>
                                                            <option value="OG">Gate Pass</option>
                                                        <?php } ?>
                                                    </select>
                                                </td>





                                                <td> <label class="control-label pull-right" style="font-weight: bold; color: black;">Base Voucher ID</label></td>




                                                <td>
                                                    <select style="width:150px;" name="base_voucher_id" id="base_voucher_id" class="acct_id">

                                                        <?php
                                                        if ($add != 'Y') {

                                                            if ($base_doc == 'QT') {
                                                                try {
                                                                    $p_query = "SELECT p.voucher_id FROM sl_quote p  ORDER BY p.voucher_id ASC ";

                                                                    $p_result = $dbcon->prepare($p_query);
                                                                    $p_result->execute(array());
                                                                } catch (PDOException $e) {
                                                                    echo "Error : " . $e->getMessage();
                                                                }
                                                            }

                                                            if ($base_doc == 'SO') {
                                                                try {
                                                                    $p_query =  "SELECT p.voucher_id FROM sl_order p  ORDER BY p.voucher_id ASC ";
                                                                    $p_result = $dbcon->prepare($p_query);
                                                                    $p_result->execute(array());
                                                                } catch (PDOException $e) {
                                                                    echo "Error : " . $e->getMessage();
                                                                }
                                                            }

                                                            if ($base_doc == 'DC') {
                                                                try {
                                                                    $p_query =  "SELECT p.voucher_id FROM sl_dc p  ORDER BY p.voucher_id ASC ";
                                                                    $p_result = $dbcon->prepare($p_query);
                                                                    $p_result->execute(array());
                                                                } catch (PDOException $e) {
                                                                    echo "Error : " . $e->getMessage();
                                                                }
                                                            }

                                                            if ($base_doc == 'OG') {
                                                                try {
                                                                    $p_query =  "SELECT p.voucher_id FROM sl_gp p  ORDER BY p.voucher_id ASC ";
                                                                    $p_result = $dbcon->prepare($p_query);
                                                                    $p_result->execute(array());
                                                                } catch (PDOException $e) {
                                                                    echo "Error : " . $e->getMessage();
                                                                }
                                                            }



                                                            while ($p_row = $p_result->fetch(PDO::FETCH_OBJ)) {

                                                                if ($new_base_voucher_id == $p_row->voucher_id) {
                                                                    echo '<option  value="' . $p_row->voucher_id . '"selected>' . $p_row->voucher_id . '</option>';
                                                                } else {
                                                                    echo '<option  value="' . $p_row->voucher_id . '">' . $p_row->voucher_id . '</option>';
                                                                }
                                                            }
                                                        }

                                                        ?>

                                                        <option value=""></option>

                                                    </select>
                                                </td>

                                


                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!------------------------END MASTER TABLE---------------------------->


                <!------------------------START DETAIL TABLE---------------------------->

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">

                                <div class="row">
                                    <div class="col-lg-6 col-md-12 col-sm-12">
                                        <input type="text"  id="proname_1" name="proname" class="form-control readonly btn-md " placeholder="Item Name / SKU" autocomplete="off">

                                    </div>

                                    <div class="col-lg-6 col-md-12 col-sm-12">
                                        <button class="btn btn-light addmore_sale font-15  pull-right ml-2 btn-lg" type="button" style="width: 205px;"><i class="fa fa-plus"></i> Add Product</button>
                                        <button class="btn btn-light delete_sale font-15 pull-right btn-lg " type="button" style="width: 205px;"><i class="fa fa-trash"></i> Delete Product</button>
                                    </div>
                                </div>



                                <br clear="all"> <br clear="all">
                                <div id="view_qty" style="color: red; font-weight: bold; text-align: center"></div>
                                <table class="table table-borderless  table-hover addrow_sale table-sm" id="addrow">
                                    <thead style="background-color: #ECECEC; color: #666666; height:40px; line-height: 40px;">
                                        <tr>
                                            <th width="2%"><input id="check_all" class="formcontrol" type="checkbox" /></th>
                                            <th width="7%" style="text-align: center;">Sr</th>
                                            <th width="10%" style="text-align: center;">Product Code</th>
                                            <th width="15%" style="text-align: center;">Product Name</th>
                                            <th width="15%" style="text-align: center;">Note</th>
                                            <th width="7%" style="text-align: center;">Stock Qty</th>
                                            <th width="7%" style="text-align: center;">Qty</th>
                                            <th width="8%" style="text-align: center;">Rate</th>
                                            <th width="8%" style="text-align: center;">Disc %</th>
                                            <th width="8%" style="text-align: center;">Disc Amt</th>
                                            <th width="22%" style="text-align: center;">Amount</th>
                                        </tr>

                                    </thead>




                                    <?php

                                    try {
                                        $edit_query =  "SELECT
d.*,
i.size,
v.bal_qty,
i.description

FROM
sl_invoicedet d
LEFT JOIN item i ON d.stock_code = i.stock_code
LEFT JOIN v_current_qty v ON i.stock_code = v.stock_code

WHERE d.voucher_id = '$v_id' and d.comp_id = '$comp_id'  AND v.comp_id = '$comp_id' AND d.year_id = '$year_id'  ORDER BY d.lineitem/1";
                                        $resultd = $dbcon->prepare($edit_query);
                                        $resultd->execute(array());
                                    } catch (PDOException $e) {
                                        echo "Error : " . $e->getMessage();
                                    }

                                    $cnt = 0;
                                    $itemtot = '';
                                    $tot_qty = '';
                                    $o_qty = '';
                                    while ($rowd = $resultd->fetch(PDO::FETCH_OBJ)) {
                                        $lineitem = $rowd->lineitem;
                                        $cnt = $lineitem;
                                        $itemtot += $rowd->itemtot;

                                        $tot_qty += $rowd->qty;

                                        $o_qty += $rowd->bal_qty;


                                    ?>

                                        <!----------------------------------------------------------------------------------------------------------------------
                        ------------------------------------------------------------------------------------------------------------------------
                        ----------------------------------------------------SALE INVOICE DETAIL EDIT FORM---------------------------------------
                        ------------------------------------------------------------------------------------------------------------------------
                        ----------------------------------------------------------------------------------------------------------------------->
                                        <tr class="addrow_sale">
                                            <td><input class="case m-t-10" type="checkbox" /></td>
                                            <td> <input type="text" class="form-control" name="lineitem[]" size="1" value="<?php echo $lineitem; ?>" readonly /></td>


                                            <!-- STOCK CODE -->
                                            <td style="width: 130px;">
                                                <input type="text" data-type="stock_code" name="stock_code[]" class="form-control form-control-sm autocomplete_txt stock_code" id="stockcode_<?php echo $cnt; ?>" value="<?php echo $rowd->stock_code; ?>" maxlength="11">
                                            </td>

                                            <!-- DESCRIPTION -->
                                            <td>
                                                <input type="text" data-type="description" name="description[]" class="form-control form-control-sm description autocomplete_txt " id="description_<?php echo $cnt; ?>" autocomplete="off" size="30" value="<?php echo $rowd->description; ?>">
                                            </td>

                                            <!-- PARTICULARS -->

                                            <td>
                                                <input type="text" class="form-control form-control-sm particulars" name="particulars[]" id="particulars_<?php echo $cnt; ?>" size="50" value="<?php echo $rowd->particulars; ?>" />
                                            </td>

                                            <td>
                                                <input type="text" class="form-control form-control-sm available_qty " name="available_qty[]" id="availableqty_<?php echo $cnt; ?>" value="<?php echo $o_qty; ?>" readonly />
                                            </td>
                                            <!-- QUANTITY -->
                                            <td>
                                                <input type="number" class="form-control form-control-sm qty changesNo qty grand_tot_qty" name="qty[]" id="qty_<?php echo $cnt; ?>" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" value="<?php echo round($rowd->qty); ?>" />
                                            </td>

                                            <!-- SCHEME -->
                                            <!-- <td>
                                <input type="number" class="form-control" name="bouns_qty[]" id="bounsqty_<?php /*echo $cnt;*/ ?>" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" value="<?php /*echo round($rowd->bouns_qty);*/ ?>" />
                            </td>-->


                                            <!-- RATE -->
                                            <td>
                                                <input type="text" class="form-control form-control-sm  changesNo orate" name="rate[]" id="orate_<?php echo $cnt; ?>" value="<?php echo round($rowd->rate); ?>" />
                                            </td>

                                            <!-- DISCOUNT -->
                                            <td>
                                                <input type="text" class="form-control form-control-sm rate changesNo discp" name="discp[]" id="discp_<?php echo $cnt; ?>" value="<?php echo round($rowd->discp); ?>" />
                                            </td>
                                            <!-- DISCOUNT VALUE -->
                                            <td>
                                                <input type="text" class="form-control form-control-sm  changesNo disc_amt" name="disc_amt[]" id="discamt_<?php echo $cnt; ?>" value="<?php echo round($rowd->disc_amt); ?>" readonly />
                                            </td>

                                            <!-- TOTAL AMOUNT -->
                                            <td>
                                                <input type="text" class="form-control  form-control-sm itemtot totalLinePrice" name="itemtot[]" id="itemtot_<?php echo $cnt; ?>" readonly value="<?php echo round($rowd->itemtot); ?>" />
                                            </td>
                                        </tr>

                                    <?php
                                    }
                                    $_SESSION['cnt'] = $cnt;
                                    ?>



                                    <!----------------------------------------------------------------------------------------------------------------------
                    ------------------------------------------------------------------------------------------------------------------------
                    ----------------------------------------------------SALE INVOICE DETAIL ADD FORM---------------------------------------
                    ------------------------------------------------------------------------------------------------------------------------
                    ----------------------------------------------------------------------------------------------------------------------->


                                    <?php $numberofrow = 1; ?> <?php for ($counter = 1; $counter <= $numberofrow; $counter++) { ?>

                                        <tr class="addrow_sale" id="hide_rowtbl">
                                            <!-- CHECKBOX FOR ADD NEW FORM FIELD -->
                                            <td>
                                                <input class="case m-t-10" type="checkbox" id="disable_<?php echo $counter; ?>" />

                                            </td>

                                            <!-- LINEITEM -->
                                            <td style="width: 60px;">
                                                <?php $lineitem += 1; ?>
                                                <input type="text" class="form-control form-control-sm " name="lineitem[]<?php echo $counter; ?>" id="lineitem_1" value="<?php echo $lineitem; ?>" readonly />
                                            </td>

                                            <!-- STOCK CODE -->
                                            <td style="width: 130px;">
                                                <input type="text" data-type="stock_code" name="stock_code[]" class="form-control form-control-sm   autocomplete_txt stock_code" id="stockcode_<?php

                                                                                                                                                                                if ($add == "Y") {
                                                                                                                                                                                    echo $counter;
                                                                                                                                                                                } else {
                                                                                                                                                                                    echo $lineitem;
                                                                                                                                                                                }


                                                                                                                                                                                ?>" autocomplete="off">
                                            </td>

                                            <!-- DESCRIPTION -->
                                            <td>
                                                <input type="text" data-type="description" name="description[]" class="form-control form-control-sm description autocomplete_txt " id="description_<?php if ($add == "Y") {
                                                                                                                                                                                        echo $counter;
                                                                                                                                                                                    } else {
                                                                                                                                                                                        echo $lineitem;
                                                                                                                                                                                    }
                                                                                                                                                                                    ?>" autocomplete="off" size="30">
                                            </td>

                                            <!-- PARTICULARS -->

                                            <td>
                                                <input type="text" class="form-control form-control-sm particulars" name="particulars[]<?php echo $counter; ?>" id="particulars" size="50" />
                                            </td>

                                            <td>
                                                <input data-toggle="modal" data-target="#view-modal" data-id="" type="text" class="form-control form-control-sm available_qty getuser " name="available_qty[]<?php echo $counter; ?>" id="availableqty_<?php if ($add == "Y") {
                                                                                                                                                                                                                                            echo $counter;
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            echo $lineitem;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        ?>" readonly />

                                            </td>

                                            <!-- QUANTITY -->
                                            <td>
                                                <input type="number" class="form-control form-control-sm qty  changesNo qty grand_tot_qty" name="qty[]<?php echo $counter; ?>" id="qty_<?php if ($add == "Y") {
                                                                                                                                                                            echo $counter;
                                                                                                                                                                        } else {
                                                                                                                                                                            echo $lineitem;
                                                                                                                                                                        }
                                                                                                                                                                        ?>" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" />
                                            </td>


                                            <!-- SCHEME -->
                                            <!--  <td>
                                <input type="number"  class="form-control" name="bouns_qty[]<?php /*echo $counter;*/ ?>" id="bounsqty_<?php /*if($add == "Y") {
                                    echo $counter;
                                }

                                else
                                {
                                    echo $lineitem;
                                }
                                */ ?>" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;"   />
                            </td>-->






                                            <!-- RATE -->
                                            <td>
                                                <input type="text" class="form-control form-control-sm  changesNo orate" name="rate[]<?php echo $counter; ?>" id="orate_<?php if ($add == "Y") {
                                                                                                                                                            echo $counter;
                                                                                                                                                        } else {
                                                                                                                                                            echo $lineitem;
                                                                                                                                                        }
                                                                                                                                                        ?>" />
                                            </td>


                                            <!-- DISCOUNT -->
                                            <td>
                                                <input type="text" class="form-control form-control-sm rate changesNo discp" name="discp[]<?php echo $counter; ?>" id="discp_<?php if ($add == "Y") {
                                                                                                                                                                    echo $counter;
                                                                                                                                                                } else {
                                                                                                                                                                    echo $lineitem;
                                                                                                                                                                }
                                                                                                                                                                ?>" />

                                            </td>


                                            <!-- DISCOUNT AMOUNT -->
                                            <td>
                                                <input type="text" class="form-control form-control-sm rate  changesNo disc_amt" name="disc_amt[]<?php echo $counter; ?>" id="discamt_<?php if ($add == "Y") {
                                                                                                                                                                            echo $counter;
                                                                                                                                                                        } else {
                                                                                                                                                                            echo $lineitem;
                                                                                                                                                                        }
                                                                                                                                                                        ?>" readonly />

                                            </td>








                                            <!-- TOTAL AMOUNT -->
                                            <td>
                                                <input type="text" class="form-control form-control-sm itemtot totalLinePrice" name="itemtot[]<?php echo $counter; ?>" id="itemtot_<?php if ($add == "Y") {
                                                                                                                                                                        echo $counter;
                                                                                                                                                                    } else {
                                                                                                                                                                        echo $lineitem;
                                                                                                                                                                    }
                                                                                                                                                                    ?>" readonly />
                                            </td>
                                        </tr>
                                    <?php } ?>


                                    <thead>
                                        <tr>


                                            <td>
                                                <i class="fa fa-trash delete_sale" data-toggle="tooltip" data-placement="top" title="Delete Product" style="position: relative; margin-top: 20px;"></i>

                                            </td>

                                            <td><i class="fa fa-plus addmore_sale" data-toggle="tooltip" data-placement="top" title="Add Product" style="position: relative; margin-top: 20px;"></i></td>



                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td align="right">

                                                <input type="text" class="form-control form-control-sm  grandtot_qty" name="grandtot_qty" id="grandtot_qty" autocomplete="off" readonly value="<?php

                                                                                                                                                                                if ($add == "Y") {
                                                                                                                                                                                    $_SESSION['tot_qty'] = 0;
                                                                                                                                                                                } else {
                                                                                                                                                                                    $_SESSION['tot_qty'] = $tot_qty;
                                                                                                                                                                                }

                                                                                                                                                                                echo round($_SESSION['tot_qty']); ?>" style="width: 100px;  font-weight: bold; position: relative; margin-top: 20px;" />
                                            </td>


                                            <td>


                                            </td>

                                            <td></td>
                                            <td></td>


                                            <td colspan="1" align="right">
                                                <input  type="text" class="form-control form-control-sm  grandtot " name="grandtot" id="grandtot" autocomplete="off" readonly value="<?php

                                                                                                                                                                    if ($add == "Y") {
                                                                                                                                                                        $_SESSION['itemtot'] = 0;
                                                                                                                                                                    } else {
                                                                                                                                                                        $_SESSION['itemtot'] = $itemtot;
                                                                                                                                                                    }

                                                                                                                                                                    echo round($_SESSION['itemtot']); ?>" style=" font-weight: bold;position: relative; margin-top: 20px;" />
                                            </td>
                                        </tr>

                                        <tr>

                                            <td colspan="9" rowspan="6">
                                                <textarea placeholder="Note:" class="purchase_note" name="purchase_note" id="purchase_note" cols="60" rows="10" style="width: 100%"><?php echo $purchase_note;?></textarea>
                                            </td>



                                            <td align="right">
                                                <b>Inv DIsc %</b>
                                            </td>
                                            <td >
                                                <input   type="text" class="form-control form-control-sm  discp_m" name="discp_m" id="discp_m" value="<?php echo round($discp_m); ?>" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" />
                                            </td>

                                        </tr>
                                        <tr>



                                            <td align="right">
                                                <b>Disc Amnt</b>
                                            </td>
                                            <td >
                                                <input type="text" class="form-control form-control-sm  disc_amt_m" name="disc_amt_m" id="disc_amt_m" value="<?php echo round($disc_amt_m); ?>" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" />
                                            </td>
                                        </tr>



                                        <tr>



                                            <td align="right">
                                                <b>Freight</b>
                                            </td>
                                            <td >
                                                <input type="text" class="form-control form-control-sm dc_amt" name="dc_amt" id="dc_amt" value="<?php echo round($dc_amt); ?>" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" />
                                            </td>
                                        </tr>








                                        <tr>



                                            <td align="right">
                                                <b>Total</b>
                                            </td>
                                            <td >
                                                <input type="text" class="form-control form-control-sm  net_amt" name="net_amt" id="net_amt" value="<?php echo round($net_amt); ?>" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return true;" readonly />
                                            </td>
                                        </tr>









                                        <tr>



                                            <td align="right">
                                                <b>Payment</b>
                                            </td>
                                            <td >
                                                <input type="text" class="form-control form-control-sm  adv_amt" name="adv_amt" id="adv_amt" value="<?php echo round($adv_amt); ?>" autocomplete="off" />
                                            </td>
                                        </tr>



                                        <tr>



                                            <td align="right">
                                                <b>Balance</b>
                                            </td>
                                            <td >
                                                <input type="text" class="form-control  form-control-sm  invoice_tot" name="invoice_tot" id="invoice_tot" value="<?php echo round($net_payable); ?>" autocomplete="off" readonly value="<?php echo $return_cash; ?>" />
                                            </td>
                                        </tr>

                                    </thead>

                                </table>


                                <div id="view"></div>
                                <div class='row'>
                                    <div class='col-xl-12 col-sm-3 col-md-3 col-lg-12'>


                                        <button type="button" class="btn btn-success btn-lg pull-right" name="savedata" id="savedata" onClick="sale_invoice_add()" style="width: 250px; height: 55px; font-weight: bold; font-size: 22px"><i class="fa fa-save"></i> Save</button>

                                        <div id="view"></div>
                                    </div>
                                </div>


            </form>



            <div id="view-modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none; ">
                <div class="modal-dialog">
                    <div class="modal-content">

                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title">
                                <i class="glyphicon glyphicon-info-sign"></i> LOCATION CURRENT STOCK
                            </h4>
                        </div>

                        <div class="table-responsive">
                            <div class="modal-body">

                                <div id="modal-loader" style="display: none; text-align: center;">
                                    <img src="dist/img/ajax-loader.gif">
                                </div>

                                <!-- content will be load here -->
                                <div id="dynamic-content"></div>

                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>

                    </div>
                </div>
            </div><!-- /.modal -->









        </div>




    </section>

</div>


<?php include('footer.php'); ?>


<!---------------------------START JAVASCRIPT-------------------------------->
<script type="text/javascript">
    /*  //price change
  $(document).on('change keyup blur','.changesNo',function() {

      var credit_limit = $('#credit_limit').val();
      var net_amt = $('#net_amt').val();
      var rate = $('#orate_1').val();


       if(parseFloat(net_amt) > parseFloat(credit_limit)) {
          alert("Donot Allow Invoice Becasue Party Credit limit Exceed.");
          $('#rate').focus();
      }


  });

*/

    //autocomplete script sale invoice select stock code
    $(document).on('focus', '.autocomplete_txt', function() {

        //            $("#acct_id").trigger("change");

        type = $(this).data('type');

        if (type == 'stock_code') autoTypeNo = 0;
        if (type == 'description') autoTypeNo = 1;


        $(this).autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: 'kt_select_stock.php',
                    dataType: "json",
                    method: 'post',
                    data: {
                        name_startsWith: request.term,
                        type: type
                    },
                    success: function(data) {




                        response($.map(data, function(item) {
                            var code = item.split("|");
                            return {
                                label: code[autoTypeNo],
                                value: code[autoTypeNo],
                                data: item
                            }
                        }));
                    }
                });
            },
            autoFocus: true,
            minLength: 0,

            select: function(event, ui) {
                var names = ui.item.data.split("|");
                id_arr = $(this).attr('id');
                id = id_arr.split("_");
                $('#stockcode_' + id[1]).val(names[0]);
                $('#description_' + id[1]).val(names[1]);
                $('#availableqty_' + id[1]).val(names[2]);
                $('#orate_' + id[1]).val(names[3]);

                s_rate = $('#orate_' + id[1]).val();
                s_qty = $('#qty_' + id[1]).val();



                $('#itemtot_' + id[1]).val(1 * names[2]);


                $('#availableqty_' + id[1]).data('id', names[0]); //sette




                $('#qty_' + id[1]).focus();

                calculateTotal();
                calculateTotal_qty();
                calculateInvoiceTotal();
                calculateNetAmount();

            }
        }).dblclick(function() {
            $(this).autocomplete("search", "");
        });

    });





    function sale_invoice_add() {

        //declare variables master form
        var v_date = $('#v_date').val();
        var v_id = $('#v_id').val();
        var acct_id = $('#acct_id').val();
        var customer_name = $('#customer_name').val();
        var customer_phone = $('#customer_phone').val();
        var customer_cash = $('#customer_cash').val();
        var return_cash = $('#return_cash').val();
        var sp = $('#sp_id').val();
        var comp_id = $('#comp_id').val();
        var credit_limit = $('#credit_limit').val();
        var net_amt = $('#net_amt').val();
        var party_bal = $('#party_bal').val();





        //declare variables detail form
        var stock_code = $('#stockcode_1').val();


        var particulars = $('#particulars').val();
        var qty = $('#qty_1').val();
        var rate = $('#orate_1').val();
        var discp = $('#discp').val();
        var itemtot = $('#itemtot').val();
        var grand_tot = $('#grandtot').val();
        var invoice_tot = $('#invoice_tot').val();


        //check condition
        if (v_id == "") {
            $.alert({

                title: "<i class='fas fa-exclamation-triangle font-25'></i> Alert",
                content: 'Please Enter Voucher ID',
                draggable: false,
                buttons: {
                    Ok: {
                        btnClass: 'btn-danger boot_box_cls_btn',

                    },
                },
                onDestroy: function() {
                    // here the button key 'hey' will be used as the text.
                    $('#v_id').focus();
                }
            });
        } else if (v_date == "") {
            $.alert({

                title: "<i class='fas fa-exclamation-triangle font-25'></i> Alert",
                content: 'Please Enter Date',
                draggable: false,
                buttons: {
                    Ok: {
                        btnClass: 'btn-danger boot_box_cls_btn',
                    },
                },
                onDestroy: function() {
                    // here the button key 'hey' will be used as the text.
                    $('#v_date').focus();
                }
            });
        } else if (acct_id == "") {
            $.alert({

                title: "<i class='fas fa-exclamation-triangle font-25'></i> Alert",
                content: 'Please Select Customer!',
                draggable: false,
                buttons: {
                    Ok: {
                        btnClass: 'btn-danger boot_box_cls_btn',

                    },
                },
                onDestroy: function() {
                    // here the button key 'hey' will be used as the text.
                    $('#acct_id').focus();
                }
            });
        }


        else if (stock_code == "") {
            $.alert({

                title: "<i class='fas fa-exclamation-triangle font-25'></i> Alert",
                content: 'Please Add Product',
                draggable: false,
                buttons: {
                    Ok: {
                        btnClass: 'btn-danger boot_box_cls_btn',

                    },
                },
                onDestroy: function() {
                    // here the button key 'hey' will be used as the text.
                    $('#stockcode_1').focus();
                }
            });
        } else if (qty == "" || qty == '0') {
            $.alert({

                title: "<i class='fas fa-exclamation-triangle font-25'></i> Alert",
                content: 'Please Enter Quantity',
                draggable: false,
                buttons: {
                    Ok: {
                        btnClass: 'btn-danger boot_box_cls_btn',
                    },
                },
                onDestroy: function() {
                    // here the button key 'hey' will be used as the text.
                    $('#qty_1').focus();
                }
            });
        } else if (rate == "") {
            $.alert({

                title: "<i class='fas fa-exclamation-triangle font-25'></i> Alert",
                content: 'Please Enter Rate',
                draggable: false,
                buttons: {
                    Ok: {
                        btnClass: 'btn-danger boot_box_cls_btn',
                    },
                },
                onDestroy: function() {
                    // here the button key 'hey' will be used as the text.
                    $('#orate_1').focus();
                }
            });
        }
        else {
            var formdata = $('#sale_invoice').serializeArray();

            $.ajax({
                type: "POST",
                url: "process/kt_sale_inv_process.php",
                data: $.param(formdata),
                beforeSend: function() {
                    $("#view").html('<div align="center"><font style="font-family:Verdana, Geneva, sans-serif; font-size:15px; color:black;"></font> Loading.... <img src="assets/img/ajax-loader.gif" alt="Loading...." align="absmiddle" title="Loading...."/></div><br clear="all">');
                },
                success: function(result) {
                    //alert(result);

                    //alert('Voucher has been successfully submitted.');
                    //window.location = "kt_sl_inv_detail.php?v_id=<?php echo $v_id; ?>&voucher_type=<?php echo $voucher_type; ?>&posted=''&p_comp_id="+comp_id;

                    window.location = "sale_invoice_detail?v_id=<?php echo $v_id; ?>&voucher_type=<?php echo $voucher_type; ?>&posted=''&p_comp_id=<?php echo $comp_id; ?>&p_year_id=<?php echo $year_id; ?>&menu_id=<?php echo $menu_id; ?>";


                }
            });
            $('.savedata').addClass("disabled");
        }




    }


    $(document).on('change', '#check_all', function() {
        $('input[class = case]:checkbox').prop("checked", $(this).is(':checked'))
    });



    //delete the selected table row

    $(".delete_sale").on('click', function() {
        $('.case:checkbox:checked').parents("tr").remove();
        $("#check_all").prop("checked", false);
        calculateTotal();
        calculateTotal_qty();
    });







    //add table rows

     i = $('.addrow_sale').length;



    $(".addmore_sale").on('click', function() {


        html = '<tr style="font-size=5px" >';
        html += '<td><input class="case" type="checkbox"/></td>';
        html += '<td><input type="text" data-type="lineitem" name="lineitem[]"  id="lineitem_' + i + '" class="form-control form-control-sm" readonly size="1" value="' + i + '"/></td>';
        html += '<td><input type="text" data-type="stock_code" name="stock_code[]" id="stockcode_' + i + '" class="form-control form-control-sm autocomplete_txt stock_code" autocomplete="off" maxlength="11"></td>';
        html += '<td><input type="text" data-type="description" name="discription[]" id="description_' + i + '" class="form-control form-control-sm autocomplete_txt" autocomplete="off" ></td>';
        html += '<td><input type="text"  name="particulars[]" id="particulars_' + i + '" class="form-control form-control-sm" autocomplete="off"></td>';
        html += '<td><input type="text" name="available_qty[]" id="availableqty_' + i + '" class="form-control form-control-sm available_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly></td>';
        html += '<td><input type="number" name="qty[]" id="qty_' + i + '" class="form-control form-control-sm qty changesNo grand_tot_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
        /*
              html += '<td><input type="number" name="bouns_qty[]" id="bounsqty_'+i+'" class="form-control" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
        */

        html += '<td><input type="text" name="rate[]" id="orate_' + i + '" class="form-control form-control-sm rate changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
        html += '<td><input type="text" name="discp[]" id="discp_' + i + '" class="form-control form-control-sm discp changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
        html += '<td><input type="text" name="disc_amt[]" id="discamt_' + i + '" class="form-control form-control-sm discamt_ changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly ></td>';

        html += '<td><input type="text" name="itemtot[]" id="itemtot_' + i + '" class="form-control form-control-sm totalLinePrice" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly></td>';

        html += '</tr>';
        $('#addrow').append(html);
        i++;
    });







    //date picker
    $('#v_date').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true
    });





    //price change
    $(document).on('change keyup blur', '.changesNo', function() {
        id_arr = $(this).attr('id');
        id = id_arr.split("_");
        avqty = $('#availableqty_' + id[1]).val();
        qty = $('#qty_' + id[1]).val();
        orate = $('#orate_' + id[1]).val();
        discp = $('#discp_' + id[1]).val();





        $('#itemtot_' + id[1]).val(getNum(parseFloat(orate) * parseFloat(qty) * (1 - discp / 100)));


        $('#discamt_' + id[1]).val(getNum((parseFloat(orate) * parseFloat(qty) * discp) / 100));



        if (parseFloat(qty) > parseFloat(avqty)) {

            var msg = "You Donot Have Required Quantity!"
            $('#view_qty').html(msg);


        }




        //if( qty!='' && orate !='' && discp !='' ) $('#itemtot_'+id[1]).val( (parseFloat(orate)*parseFloat(qty)).toFixed(2)*(1-discp/100) );

        calculateTotal();
        calculateTotal_qty();
        calculateInvoiceTotal();
        calculateNetAmount();

    });




    /*****************START DISCOUNT PERCENTAGE**************/
    $(document).on('change keyup blur', '.changesdiscp', function() {
        grandtot = $('#grandtot').val();
        qty = $('#qty_' + id[1]).val();
        orate = $('#orate_' + id[1]).val();
        discp = $('#discp_' + id[1]).val();


        $('#itemtot_' + id[1]).val(parseFloat(orate) * parseFloat(qty) * (1 - discp / 100));




    });
    /*****************END DISCOUNT PERCENTAGE**************/




    /****************START INVOICE TOTAL****************/
    function calculateInvoiceTotal() {
        grandtot = 0;
        itemtot = 0;
        $('.totalLinePrice').each(function() {
            if ($(this).val() != '') grandtot += parseFloat($(this).val());
        });
        $('#invoice_tot').val(grandtot);
        itemtot += grandtot;
    }
    /****************END INVOICE TOTAL****************/



    /****************START NET AMOUNT AFTER DISCOUNT****************/
    function calculateNetAmount() {
        grandtot = 0;
        itemtot = 0;
        $('.totalLinePrice').each(function() {
            if ($(this).val() != '') grandtot += parseFloat($(this).val());
        });
        $('#net_amt').val(grandtot);
        itemtot += grandtot;
    }
    /****************END NET AMOUNT AFTER DISCOUNT****************/



    /*****************START MASTER DISCOUNT PERCENTAGE**************/
    $(document).on('change keyup blur', '#discp_m', function() {
        grandtot = $('#grandtot').val();
        discp_m = $('#discp_m').val();
        net_amt = $('#net_amt').val();

        $('#net_amt').val(parseFloat(grandtot) * (1 - discp_m / 100));

        $('#invoice_tot').val(parseFloat(grandtot) * (1 - discp_m / 100));

        $('#disc_amt_m').val((parseFloat(grandtot) * discp_m) / 100);

    });
    /*****************END MASTER DISCOUNT PERCENTAGE**************/


    /*****************START MASTER DISCOUNT AMOUNT MANNUL TYPE PERCENTAGE**************/
    $(document).on('change keyup blur', '#disc_amt_m', function() {
        grandtot = $('#grandtot').val();
        disc_amt_m = $('#disc_amt_m').val();






        $('#net_amt').val(parseFloat(grandtot) - parseFloat(disc_amt_m));

        $('#invoice_tot').val(parseFloat(grandtot) - parseFloat(disc_amt_m));

    });
    /*****************END MASTER DISCOUNT AMOUNT MANNUL TYPE PERCENTAGE**************/




    /*****************START FREIGHT AMOUNT*************/
    $(document).on('change keyup blur', '#dc_amt', function() {
        grandtot = $('#grandtot').val();
        dc_amt = $('#dc_amt').val();
        disc_amt_m = $('#disc_amt_m').val();


        if (disc_amt_m == '') {
            $('#net_amt').val(parseFloat(grandtot) + parseFloat(dc_amt));

            $('#invoice_tot').val(parseFloat(grandtot) + parseFloat(dc_amt));

        } else {
            $('#net_amt').val(parseFloat(grandtot) - parseFloat(disc_amt_m) + parseFloat(dc_amt));

            $('#invoice_tot').val(parseFloat(grandtot) - parseFloat(disc_amt_m) + parseFloat(dc_amt));
        }




    });
    /*****************END FREIGHT AMOUNT*************/







    /*****************START MASTER DISCOUNT PERCENTAGE**************/
    /*$(document).on('change keyup blur', '#discp_m', function () {
     grandtot = $('#grandtot').val();
     discp_m = $('#discp_m').val();
     adv_amt = $('#adv_amt').val();

     if ($('#adv_amt').val() != '') {
     $('#invoice_tot').val(parseFloat(grandtot) * (1 - discp_m / 100) - parseFloat(adv_amt));
     }
     else
     {
     $('#invoice_tot').val(parseFloat(grandtot) * (1 - discp_m / 100));
     }

     });*/
    /*****************END MASTER DISCOUNT PERCENTAGE**************/



    /*****************START ADVANCE AMOUNT**************/
    $(document).on('change keyup blur', '#adv_amt', function() {
        grandtot = $('#grandtot').val();
        adv_amt = $('#adv_amt').val();
        discp_m = $('#discp_m').val();
        net_amt = $('#net_amt').val();

        disc_amt_m = $('#disc_amt_m').val();


        // $('#invoice_tot').val(Math.round(parseFloat(net_amt) * (1 - discp_m / 100) - parseFloat(adv_amt)) );

        $('#invoice_tot').val(Math.round(parseFloat(net_amt) - parseFloat(adv_amt)));




    });
    /*****************END ADVANCE AMOUNT**************/







    //total price calculation
    function calculateTotal() {
        grandtot = 0;
        itemtot = 0;
        $('.totalLinePrice').each(function() {
            if ($(this).val() != '') grandtot += parseFloat($(this).val());
        });
        $('#grandtot').val(grandtot);
        itemtot += grandtot;

        var grand_tot = $('#grandtot').val();

        //alert(grand_tot);


        var freight_tot = $('#freight').val();

        var inv_tot = parseFloat(grand_tot) - parseFloat(freight_tot);

        $('#invoice_tot').val(inv_tot);


    }

    //total pqty calculation
    function calculateTotal_qty() {
        grandtot_qty = 0;
        qty = 0;
        $('.grand_tot_qty').each(function() {
            if ($(this).val() != '') grandtot_qty += parseFloat($(this).val());
        });
        $('#grandtot_qty').val(grandtot_qty);
        qty += grandtot_qty;
    }




    //customer cash calculate
    $(document).on('change keyup blur', '#customer_cash', function() {

        grandtot = $('#grandtot').val();
        customer_cash = $('#customer_cash').val();
        //invoice_tot = $('#invoice_tot').val();


        $('#return_cash').val(parseFloat(customer_cash) - parseFloat(grandtot));

    });





    //LOAD DROP DOWN WITH BASE DOC VOUCHER ID
    $('#base_doc').change(function() {
        var base_doc = $('#base_doc').val();


        var datasend = 'base_doc=' + base_doc;

        $('#loaderc').fadeIn(400).html('<img src="images/ajax-loader.gif" align="absmiddle">');

        $.ajax({

            type: "POST",
            data: datasend,
            url: 'ajax/select_base_voucher_id.php',
            cache: false,
            success: function(msg) {

                //alert(msg);

                $('#base_voucher_id').html(msg);

                $('#loaderc').fadeOut("slow");

            }

        });




    });




    /**********************START AUTO LOAD ITEM LIST**********************/
    $("#base_voucher_id").on("change", function() {

        var base_doc = $("#base_doc").val();

        var base_voucher_id = $("#base_voucher_id").val();

        var action = 'voucher_load';


        var dataString = 'base_doc=' + base_doc + '&base_voucher_id=' + base_voucher_id + '&action=' + action;



        $.ajax({
            type: "POST",
            data: dataString,
            url: "ajax/get_sale_quote_voucher.php",
            dataType: "json",
            success: function(JSONObject) {
                var peopleHTML = "";

                // Loop through Object and create peopleHTML
                var i = 1;

                for (var key in JSONObject) {
                    if (JSONObject.hasOwnProperty(key)) {
                        //$("#v_date").val(JSONObject[key]["voucher_date"]);




                        $("#acct_id").val(JSONObject[key]["acct_id"]);

                        $("#net_amt").val(JSONObject[key]["net_amt"]);
                        $("#adv_amt").val(JSONObject[key]["adv_amt"]);
                        $("#invoice_tot").val(JSONObject[key]["net_payable"]);

                        $("#grandtot_qty").val(JSONObject[key]["q_tot"]);

                        $("#grandtot").val(JSONObject[key]["grandtot"]);




                        peopleHTML += '<tr>';
                        peopleHTML += '<td><input class="case" type="checkbox"/></td>';
                        peopleHTML += '<td><input type="text" data-type="lineitem" name="lineitem[]"  id="lineitem_' + i + '" class="form-control" readonly size="1" value="' + JSONObject[key]["lineitem"] + '"/></td>';
                        peopleHTML += '<td><input type="text" data-type="stock_code" name="stock_code[]" id="stockcode_' + i + '" value="' + JSONObject[key]["stock_code"] + '" class="form-control autocomplete_txt stock_code" autocomplete="off" maxlength="11"></td>';
                        peopleHTML += '<td><input type="text" data-type="description" name="discription[]" id="description_' + i + '" value="' + JSONObject[key]["stock_name"] + '" class="form-control autocomplete_txt" autocomplete="off" ></td>';
                        peopleHTML += '<td><input type="text"  name="particulars[]" id="particulars_' + i + '" value="" class="form-control" autocomplete="off" ></td>';
                        peopleHTML += '<td><input type="text" name="available_qty[]" id="availableqty_' + i + '" value="" class="form-control available_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly></td>';
                        peopleHTML += '<td><input type="number" name="qty[]" id="qty_' + i + '" value="' + JSONObject[key]["qty"] + '" class="form-control qty changesNo grand_tot_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
                        peopleHTML += '<td><input type="text" name="rate[]" id="orate_' + i + '" value="' + JSONObject[key]["rate"] + '" class="form-control rate changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
                        peopleHTML += '<td><input type="text" name="discp[]" id="discp_' + i + '" value="' + JSONObject[key]["discp"] + '" class="form-control discp changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
                        peopleHTML += '<td><input type="text" name="disc_amt[]" id="discamt_' + i + '" value="' + JSONObject[key]["disc_amt"] + '" class="form-control discamt_ changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly ></td>';
                        peopleHTML += '<td><input type="text" name="itemtot[]" id="itemtot_' + i + '" value="' + JSONObject[key]["itemtot"] + '" class="form-control totalLinePrice" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly></td>';
                        peopleHTML += '</tr>';
                        i++;


                    }
                }

                // Replace table’s tbody html with peopleHTML
                $("#addrow tbody").html(peopleHTML);
                $('.remove_acct_id').select2('destroy');
            }
        });
    });
    /**********************END AUTO LOAD ITEM LIST**********************/











    /**********************START AUTO LOAD VOUCHER ID FROM PARTY LIST**********************/
    $("#acct_id").on("change", function() {

        var acct_id = $("#acct_id").val();

        var base_voucher_id = $("#base_voucher_id").val();

        var action = 'voucher_id_load';


        var dataString = 'acct_id=' + acct_id + '&action=' + action;



        $.ajax({
            type: "POST",
            data: dataString,
            url: "ajax/get_base_vouchers",
            dataType: "json",
            success: function(JSONObject) {
                var peopleHTML = "";

                // Loop through Object and create peopleHTML
                var i = 1;

                for (var key in JSONObject) {
                    if (JSONObject.hasOwnProperty(key)) {
                        //$("#v_date").val(JSONObject[key]["voucher_date"]);
                        $("#acct_id").val(JSONObject[key]["acct_id"]);

                        $("#net_amt").val(JSONObject[key]["net_amt"]);
                        $("#adv_amt").val(JSONObject[key]["adv_amt"]);
                        $("#invoice_tot").val(JSONObject[key]["net_payable"]);
                        $("#grandtot").val(JSONObject[key]["item_tot"]);
                        $("#grandtot_qty").val(JSONObject[key]["q_tot"]);





                        peopleHTML += '<tr>';
                        peopleHTML += '<td><input class="case" type="checkbox"/></td>';
                        peopleHTML += '<td><input type="text" data-type="lineitem" name="lineitem[]"  id="lineitem_' + i + '" class="form-control" readonly size="1" value="' + JSONObject[key]["lineitem"] + '"/></td>';
                        peopleHTML += '<td><input type="text" data-type="stock_code" name="stock_code[]" id="stockcode_' + i + '" value="' + JSONObject[key]["stock_code"] + '" class="form-control autocomplete_txt stock_code" autocomplete="off" maxlength="11"></td>';
                        peopleHTML += '<td><input type="text" data-type="description" name="discription[]" id="description_' + i + '" value="' + JSONObject[key]["stock_name"] + '" class="form-control autocomplete_txt" autocomplete="off" ></td>';
                        peopleHTML += '<td><input type="text"  name="particulars[]" id="particulars_' + i + '" value="" class="form-control" autocomplete="off" ></td>';
                        peopleHTML += '<td><input type="text" name="available_qty[]" id="availableqty_' + i + '" value="" class="form-control available_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly></td>';
                        peopleHTML += '<td><input type="number" name="qty[]" id="qty_' + i + '" value="' + JSONObject[key]["qty"] + '" class="form-control qty changesNo grand_tot_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
                        peopleHTML += '<td><input type="text" name="rate[]" id="orate_' + i + '" value="' + JSONObject[key]["rate"] + '" class="form-control rate changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
                        peopleHTML += '<td><input type="text" name="discp[]" id="discp_' + i + '" value="' + JSONObject[key]["discp"] + '" class="form-control discp changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" ></td>';
                        peopleHTML += '<td><input type="text" name="disc_amt[]" id="discamt_' + i + '" value="' + JSONObject[key]["discount"] + '" class="form-control discamt_ changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly ></td>';
                        peopleHTML += '<td><input type="text" name="itemtot[]" id="itemtot_' + i + '" value="' + JSONObject[key]["itemtot"] + '" class="form-control totalLinePrice" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly></td>';
                        peopleHTML += '</tr>';
                        i++;


                    }
                }

                // Replace table’s tbody html with peopleHTML
                $("#addrow tbody").html(peopleHTML);
            }
        });
    });
    /**********************START AUTO LOAD VOUCHER ID FROM PARTY LIST**********************/










    /*******************START GET ITEM LIST FORM ENTER****************/

    //r = 1;
    $('#proname_1').keypress(function(e) {


        if (e.which == 13) {



            var proname_1 = $("#proname_1").val();
            html = '';
            var action = 'search_item';
            var dataString = 'proname_1=' + proname_1 + '&action=' + action;

            $.ajax({
                type: "POST",
                url: "search_item",
                data: dataString,
                success: function(data) {

                    $('#cover-spin').hide();
                    var json = JSON.parse(data);
                    //console.log(json);

                    var status = json[0].status;
                    var count = json[0].count;
                    var result = json[0].result;
                    var text = '';

                    new_stock_code = result[0]['stock_code'];
                    var q = 1;


                    if (status == 1) {

                       

                        // Check if code exists
                        var exists = false;
                        $('#addrow tbody tr').each(function(tr) {
                            var currentRow = $(this).closest("tr");
                            var item_code = currentRow.find("td:eq(2) input").val();

                            if (item_code == new_stock_code) {


                                // Flag exists
                                exists = true;
                                $(this).data('qty', parseInt(q) + parseInt($(this).find('.qty').val()));

                                // Update table with new value
                                $('.qty', this).val($(this).data('qty'));
                                $('.qty', this).html($(this).data('qty'));
                                //$('.qty', this).val(qty);


                            }

                        });

                        if (!exists) {


                            //var i = $('.addrow_sale').length;

                            html_row = '<tr style="font-size=5px">';
                            html_row += '<td><input class="case" type="checkbox"/></td>';
                            html_row += '<td><input type="text" data-type="lineitem" name="lineitem[]"  id="lineitem_' + r + '" class="form-control form-control-sm" readonly value="' + r + '"/></td>';
                            html_row += '<td><input type="text" data-type="stock_code" name="stock_code[]" id="stockcode_' + r + '" class="form-control form-control-sm autocomplete_txt stock_code" autocomplete="off" value="' + result[0]['stock_code'] + '"></td>';
                            html_row += '<td><input type="text" data-type="description" name="discription[]" id="description_' + r + '" class="form-control form-control-sm autocomplete_txt" autocomplete="off" value="' + result[0]['description'] + '"></td>';
                            html_row += '<td><input type="text"  name="particulars[]" id="particulars_' + r + '" class="form-control form-control-sm" autocomplete="off"></td>';
                            html_row += '<td><input type="text" name="available_qty[]" id="availableqty_' + r + '" class="form-control form-control-sm available_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly value="' + result[0]['bal_qty'] + '"></td>';
                            html_row += '<td><input type="number" name="qty[]" id="qty_' + r + '" class="form-control form-control-sm qty changesNo grand_tot_qty" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" value="' + q + '" ></td>';
                            html_row += '<td><input type="text" name="rate[]" id="orate_' + r + '" class="form-control form-control-sm rate changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" value="' + result[0]['s_rate'] + '"></td>';
                            html_row += '<td><input type="text" name="discp[]" id="discp_' + r + '" class="form-control form-control-sm discp changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;"></td>';
                            html_row += '<td><input type="text" name="disc_amt[]" id="discamt_' + r + '" class="form-control form-control-sm discamt_ changesNo" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly ></td>';
                            html_row += '<td><input type="text" name="itemtot[]" id="itemtot_' + r + '" class="form-control form-control-sm totalLinePrice" autocomplete="off" onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" readonly ></td>';
                            html_row += '</tr>';
                            $('#addrow tbody').append(html_row);


                            r++;


                        }

                        calculateTotal();
                        calculateTotal_qty();
                        calculateInvoiceTotal();
                        calculateNetAmount();




                       /* $("#proname_1").val(result[0]['stock_name']);

                        var product = {
                            procode: result[0]['stock_code'],
                            prname: result[0]['stock_name'],
                            qty: 1,
                            current_qty: result[0]['current_qty'],
                            price: result[0]['s_rate'],
                            disc: result[0]['discp'],
                            tax_p: result[0]['tax_rate'],

                            tot_cost: 0,

                            date_from: result[0]['date_from'],
                            date_to: result[0]['date_to'],


                        };*/

                       // addRowitemList(product);





                    } else if (status == 0) {
                        $.alert('No data available', {

                            autoClose: true,
                            type: 'danger',
                            position: ['center', [-0.42, 0]],
                            closeTime: 2000,
                            close: '',
                            minTop: 10,


                        });


                    }



                }

            })
        }



    });
    /*******************END GET ITEM LIST FORM ENTER****************/







    function addRowitemList(product) {
        var c = product.procode;
        var q = 1;

        stock = c;
        total_disc_amt = 0;
        total_tax_amt = 0;
        tax_amt = 0;
        total_price = 0;
        total = 0;
        total_qty = 0






        if (product.current_qty == 0) {
            $.alert('You Donot Have Required Quantity!', {

                autoClose: true,
                type: 'danger',
                position: ['center', [-0.42, 0]],
                closeTime: 2000,
                close: '',
                minTop: 10,


            });


        } else {





            sr = 1;
            $('#productlist').show();
            var $tableB = $('#addrow tbody');
            var $row = $(
                "<tr style='text-align: center'>" +
                "<td>" +
                '<input class="case" type="checkbox"/>'+
                "</td>" +
                "<td class='line_item'  style='display: none;'>" + sr + "</td>" +
                "<td>" + product.procode + "</td>" +
                "<td>" + product.prname + "</td>" +
                "<td class='totalLineQty'>" + '<input type="number" name="qty" id="qty_' + sr + '" value="1" class="form-control  changesNo readonly qty " style="width: 100%; text-align: center" >' + "</td>" +
                "<td  style='display: none;' >" + product.current_qty + "</td>" +

                "<td>" + '<input onkeypress="return IsNumeric(event);" ondrop="return false;" onpaste="return false;" type="text" name="price_1" id="price_' + sr + '" value=' + product.price + ' class="form-control  changesPrice valid_price number-separator changesNo" style="width: 100%; text-align: center;" >' + "</td>" +


                "<td>" + '<input type="text" name="disc" id="disc_' + sr + '" value=' + product.disc + '   class="form-control  disc_change changesNo readonly number-separator " style="width: 100%; text-align: center"  >' + "</td>" +



                "<td>" + '<input type="text" name="d_staxp" id="dstaxp_' + sr + '" value=' + product.tax_p + '   class="form-control" style="width: 100%; text-align: center" readonly>' + "</td>" +
                "<td style='display: none;'   >" + tax_amt + "</td>" +



                "<td class='totalLinePrice'>" + (product.tot_cost) + "</td>" +
                "</tr>"


            );



            // Check if code exists
            var exists = false;
            $('#productlist tbody tr').each(function() {
                // If exists a product with the same productCode...

                var item_code = $(this).data('procode')

                if (item_code == c) {


                    // Flag exists
                    exists = true;
                    $(this).data('qty', parseInt(q) + parseInt($(this).find('.qty').val()));

                    // Update table with new value
                    $('.qty', this).val($(this).data('qty'));
                    $('.qty', this).html($(this).data('qty'));
                    //$('.qty', this).val(qty);


                    var $row = $(this).closest('tr');
                    qty = $row.find("td:eq(4) input").val();
                    orate = $row.find("td:eq(6) input").val().replace(/,/g, "");
                    disc = $row.find('td').eq(8).text();
                    // $row.find('td').eq(11).text(addCommas(Number(qty * orate)));
                    discp = $(this).closest('tr').find("td:eq(7) input").val();


                }

            });

            if (!exists) {

                $row.data("lineitem", product.sr);
                $row.data("procode", product.procode);
                $row.data("prname", product.prname);
                $row.data("qty", product.qty);
                $row.data("price", product.price);

                $row.data("tax_amt", tax_amt);
                $row.data("tot_cost", product.tot_cost);

                $tableB.append($row);




                total += (product.tot_cost);
                total_qty += (product.qty);

                //total_tax_amt +=  (tax_amt);





                $('#sub_total').val(total);
                $('#total_invoice').val(total);

                // $('#staxp').val(total_tax_amt);
                //$('#invoice_total_normal').text(total_disc_amt);




                $('.cash_amt').val(total);
                $('.pay').val(total);
                $('#sub_total_normal').text(total);
                $('#invoice_total_normal').text(total);
                // $('#payment_balance').val(total);




                disc = $('#disc_1').val();


                $('#productlist tbody tr').each(function() {

                    var $row = $(this).closest('tr');
                    qty = $row.find("td:eq(4) input").val();
                    orate = $row.find("td:eq(6) input").val().replace(/,/g, "");

                    disc = $row.find('td').eq(8).text();
                    $row.find('td').eq(11).text(addCommas(Number(qty * orate)));

                    discp = $(this).closest('tr').find("td:eq(7) input").val();
                    disc = $row.find('td').eq(8).text();
                    tax_amt = $row.find('td').eq(10).text();
                    //  disc_amt = $row.find('td').eq(10).text((orate.replace(/,/g, "")) * (1 - discp / 100));

                    if (discp == 0) {
                        disc_amt = 0;
                    } else {
                        if (disc_value == 'P') {
                            disc_amt = $row.find('td').eq(8).text((qty * orate.replace(/,/g, "")) * (1 - discp / 100));


                            total_price = (qty * orate) - disc_amt;

                            $row.find('td').eq(11).text(addCommas(Number(total_price)));




                        } else {
                            disc_amt = $row.find('td').eq(8).text(disc);

                        }

                    }

                })


            }

        }


        total += (product.tot_cost);
        total_qty += (product.qty);
        total_disc_amt += (product.disc_amt);
        // total_tax_amt +=  (tax_amt);








        $('#productlist tbody tr').each(function() {

            var $row = $(this).closest('tr');
            qty = $row.find("td:eq(4) input").val();
            orate = $row.find("td:eq(6) input").val().replace(/,/g, "");
            discp = $row.find("td:eq(7) input").val();
            disc = $row.find('td').eq(8).text();
            $row.find('td').eq(11).text(addCommas(Number(qty * orate)));

            // discp = $(this).closest('tr').find("td:eq(7) input").val();





            if (discp == 0) {
                disc_amt = 0;
            } else {
                if (disc_value == 'P') {
                    $row.find('td').eq(8).text((qty * orate) * (1 - discp / 100));
                    disc_amt = $row.find('td').eq(8).text();


                    total_price = (qty * orate.replace(/,/g, ""));
                    $row.find('td').eq(11).text(addCommas(Number(total_price - disc_amt)));
                } else {
                    disc_amt = $row.find('td').eq(8).text(disc);

                    $row.find('td').eq(11).text(addCommas(Number(total_price - disc_amt)));

                }
            }



        });








        $('#sub_total').val(total);
        $('#total_invoice').val(total);
        $('#total_qty').val();
        //  $('#disc_amt').val(total_disc_amt);




        $('.cash_amt').val(total);
        $('.pay').val(total);
        $('#sub_total_normal').text(total);
        $('#invoice_total_normal').text(total);
        //$('#payment_balance').val(total);


        calculateTotal();


        var proname_1 = $("#proname_1").val('');


        $(".form-control").click(function() {
            $(this).select();
        });
    }



 /*   $('#proname_1').click(function() {
        $("#hide_rowtbl").remove();

    });*/

</script>
<!---------------------------START JAVASCRIPT-------------------------------->